package net.w_horse.excelpojo.xml;

import static org.junit.Assert.assertEquals;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.junit.Test;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import test.xml.ReservedWordTest;
import net.w_horse.excelpojo.AbstractTest;
import net.w_horse.excelpojo.ExcelPOJOBridge;
import net.w_horse.excelpojo.ExcelPOJOException;

public class ConstantValueTest extends AbstractTest {
	/**
	 * \̃eXg
	 *
	 * @throws ExcelPOJOException
	 * @throws IOException
	 * @throws ParseException
	 */
	@Test
	public void testConstantValueReservedWord() throws ExcelPOJOException, IOException, ParseException {
		ApplicationContext context = new ClassPathXmlApplicationContext("./config/testConstantValueReservedWord.xml");
		ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("testConstantValueReservedWord");

		String beforeLoad = (new SimpleDateFormat("HHmmss")).format(new Date());
		// V[g͂ǂǂł
		ReservedWordTest targetBean = (ReservedWordTest) bridge.load("./files/upload/ParserTest.xls", "xǂݍ݈ʒu");
		String afterLoad = (new SimpleDateFormat("HHmmss")).format(new Date());

		String todayYYYYMMDD = (new SimpleDateFormat("yyyyMMdd")).format(new Date());
		assertEquals("ConstantValue yyyyMMdd", todayYYYYMMDD, targetBean.getYyyyMMdd());

		String todaySL_YMD = (new SimpleDateFormat("yyyy/MM/dd")).format(new Date());
		assertEquals("ConstantValue yyyy/MM/dd", todaySL_YMD, targetBean.getSl_ymd());

		String todayHP_YMD = (new SimpleDateFormat("yyyy-MM-dd")).format(new Date());
		assertEquals("ConstantValue yyyy-MM-dd", todayHP_YMD, targetBean.getHp_ymd());

		String todayHHMMSS = targetBean.getHhmmss();	// s~bŏIs̑OœlɂȂ\
		assertEquals("ConstantValue HHmmss", true, todayHHMMSS.compareTo(beforeLoad) >= 0);
		assertEquals("ConstantValue HHmmss", true, todayHHMMSS.compareTo(afterLoad) <= 0);
	}
}
